/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.ui.SidebarPanel;
import net.minecraft.launcher.ui.tabs.LauncherTabPanel;

public class LauncherPanel
extends JPanel {
    private final LauncherTabPanel tabPanel;
    private final SidebarPanel sidebar;
    private final JProgressBar progressBar;
    private final Launcher launcher;

    public LauncherPanel(Launcher launcher) {
        this.launcher = launcher;
        this.setLayout(new BorderLayout());
        this.progressBar = new JProgressBar();
        this.sidebar = new SidebarPanel(launcher);
        this.tabPanel = new LauncherTabPanel(launcher);
        this.createInterface();
    }

    protected void createInterface() {
        this.tabPanel.getBlog().setPage("http://mcupdate.tumblr.com");
        this.progressBar.setVisible(false);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.add((Component)this.tabPanel, "Center");
        this.add((Component)this.sidebar, "East");
        this.add((Component)this.progressBar, "South");
    }

    public LauncherTabPanel getTabPanel() {
        return this.tabPanel;
    }

    public SidebarPanel getSidebar() {
        return this.sidebar;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public Launcher getLauncher() {
        return this.launcher;
    }
}

