/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.sidebar.login;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.authentication.AuthenticationService;
import net.minecraft.launcher.ui.sidebar.login.LoggedInForm;
import net.minecraft.launcher.ui.sidebar.login.NotLoggedInForm;

public class LoginContainerForm
extends JPanel {
    private static final String CARD_LOGGED_IN = "Logged In";
    private static final String CARD_NOT_LOGGED_IN = "Not Logged In";
    private final Launcher launcher;
    private final LoggedInForm loggedInForm;
    private final NotLoggedInForm notLoggedInForm;
    private final CardLayout layout = new CardLayout();

    public LoginContainerForm(Launcher launcher) {
        super(true);
        this.launcher = launcher;
        this.loggedInForm = new LoggedInForm(this);
        this.notLoggedInForm = new NotLoggedInForm(this);
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 300));
        this.setLayout(this.layout);
        this.add((Component)this.loggedInForm, CARD_LOGGED_IN);
        this.add((Component)this.notLoggedInForm, CARD_NOT_LOGGED_IN);
        this.layout.show(this, CARD_NOT_LOGGED_IN);
    }

    public void checkLoginState() {
        AuthenticationService authentication = this.launcher.getProfileManager().getSelectedProfile().getAuthentication();
        this.notLoggedInForm.checkLoginState();
        this.loggedInForm.checkLoginState();
        if (authentication.isLoggedIn()) {
            this.layout.show(this, CARD_LOGGED_IN);
        } else {
            this.layout.show(this, CARD_NOT_LOGGED_IN);
        }
    }

    public NotLoggedInForm getNotLoggedInForm() {
        return this.notLoggedInForm;
    }

    public Launcher getLauncher() {
        return this.launcher;
    }
}

